/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.mint;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseToggleButtonUI;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JMenuBar;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;

public class MintToggleButtonUI
extends BaseToggleButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new MintToggleButtonUI();
    }

    @Override
    protected void paintBackground(Graphics g, AbstractButton b) {
        if (!b.isContentAreaFilled() || b.getParent() instanceof JMenuBar) {
            return;
        }
        if (b.getWidth() < 32 || b.getHeight() < 16 || !b.isBorderPainted() || !(b.getBorder() instanceof UIResource) || AbstractLookAndFeel.getTheme().doDrawSquareButtons()) {
            ButtonModel model = b.getModel();
            ColorUIResource color = AbstractLookAndFeel.getTheme().getButtonBackgroundColor();
            if (model.isPressed() && model.isArmed() || model.isSelected()) {
                color = AbstractLookAndFeel.getTheme().getPressedBackgroundColor();
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                color = AbstractLookAndFeel.getTheme().getRolloverColor();
            }
            g.setColor(color);
            g.fillRect(0, 0, b.getWidth(), b.getHeight());
            if (model.isPressed() && model.isArmed() || model.isSelected()) {
                JTattooUtilities.draw3DBorder(g, Color.lightGray, Color.white, 0, 0, b.getWidth(), b.getHeight());
            } else {
                JTattooUtilities.draw3DBorder(g, Color.white, Color.lightGray, 0, 0, b.getWidth(), b.getHeight());
            }
            return;
        }
        Graphics2D g2D = (Graphics2D)g;
        int width = b.getWidth() - 2;
        int height = b.getHeight() - 2;
        ButtonModel model = b.getModel();
        if (model.isPressed() && model.isArmed()) {
            ColorUIResource color = AbstractLookAndFeel.getTheme().getPressedBackgroundColor();
            g2D.setColor(color);
            g2D.fillRoundRect(0, 0, width, height, height, height);
            g2D.setColor(AbstractLookAndFeel.getTheme().getFrameColor());
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.drawRoundRect(0, 0, width - 1, height - 1, height, height);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
            return;
        }
        if (model.isSelected()) {
            Shape savedClip = g2D.getClip();
            Area area = new Area(new Area(new RoundRectangle2D.Double(0.0, 0.0, width, height, height, height)));
            g2D.setClip(area);
            JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getPressedColors(), 0, 0, width, height);
            g2D.setClip(savedClip);
            g2D.setColor(ColorHelper.darker(AbstractLookAndFeel.getTheme().getPressedBackgroundColor(), 10.0));
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.drawRoundRect(0, 0, width - 1, height - 1, height, height);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
            return;
        }
        Color[] colors = AbstractLookAndFeel.getTheme().getButtonColors();
        if (!model.isEnabled()) {
            colors = AbstractLookAndFeel.getTheme().getDisabledColors();
        } else if (b.isRolloverEnabled() && model.isRollover()) {
            Color[] src = AbstractLookAndFeel.getTheme().getRolloverColors();
            colors = new Color[src.length];
            System.arraycopy(src, 0, colors, 0, colors.length);
            colors[colors.length - 2] = ColorHelper.darker(colors[colors.length - 2], 15.0);
        }
        Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color color = b.getParent().getBackground();
        g2D.setColor(ColorHelper.darker(color, 6.0));
        g2D.drawRoundRect(2, 2, width - 1, height - 1, height, height);
        g2D.setColor(ColorHelper.darker(color, 18.0));
        g2D.drawRoundRect(1, 1, width - 1, height - 1, height, height);
        int x = 0;
        int y = 0;
        int w = width;
        int h = height;
        for (int i = colors.length - 1; i >= 0; --i) {
            g2D.setColor(colors[i]);
            g2D.fillRoundRect(x, y, w, h, h, h);
            --h;
            --w;
            if ((i + 1) % 4 == 0) {
                ++x;
                ++y;
            }
            if (h == 0) break;
        }
        g2D.setColor(Color.white);
        g2D.drawRoundRect(1, 1, width - 3, height - 3, height - 2, height - 2);
        g2D.drawRoundRect(1, 1, width - 3, height - 3, height - 2, height - 2);
        g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        Graphics2D g2D = (Graphics2D)g;
        int width = b.getWidth();
        int height = b.getHeight();
        if (!(!AbstractLookAndFeel.getTheme().doDrawSquareButtons() && b.isContentAreaFilled() && b.getBorder() instanceof UIResource && (width >= 64 && height >= 16 || b.getText() != null && b.getText().length() != 0))) {
            g.setColor(AbstractLookAndFeel.getFocusColor());
            BasicGraphicsUtils.drawDashedRect(g, 4, 3, width - 8, height - 6);
        } else {
            Object savedRenderingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2D.setColor(AbstractLookAndFeel.getFocusColor());
            int d = height - 6;
            g2D.drawRoundRect(2, 2, width - 7, height - 7, d, d);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRenderingHint);
        }
    }
}

