/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpersona.uareu.jni;

import com.digitalpersona.uareu.Engine;
import com.digitalpersona.uareu.Fid;
import com.digitalpersona.uareu.Fmd;
import com.digitalpersona.uareu.UareUException;
import com.digitalpersona.uareu.dpfj.FmdImpl;
import com.digitalpersona.uareu.dpfpdd.FidImpl;

public class Dpfj {
    private Fmd.Format m_enrollment_fmd_format;

    public native int DpfjImportFmd(int var1, byte[] var2, int var3, FmdImpl var4);

    public native int DpfjImportDpFid(byte[] var1, int var2, int var3, int var4, FidImpl var5);

    public native int DpfjImportFid(byte[] var1, int var2, FidImpl var3);

    public native int DpfjCreateFmdFromRaw(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7, FmdImpl var8);

    public native int DpfjCreateFmdFromFid(byte[] var1, int var2, int var3, int var4, FmdImpl var5);

    public native int DpfjCompare(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6, IntReference var7);

    public native int DpfjIdentify(byte[] var1, int var2, int var3, byte[][] var4, int var5, int var6, IntReference var7, Engine.Candidate[] var8);

    public native int DpfjStartEnrollment(int var1);

    public native int DpfjAddToEnrollment(byte[] var1, int var2, int var3);

    public native int DpfjCreateEnrollmentFmd(int var1, FmdImpl var2);

    public native int DpfjFinishEnrollment();

    public Dpfj() {
        System.loadLibrary("dpuareu_jni");
    }

    public Fmd import_fmd(byte[] fmd_data, Fmd.Format fmd_format, Fmd.Format fmd_format_to) throws UareUException {
        FmdImpl fmd_to;
        int fmd_fmt_to;
        byte nViewCnt = 0;
        switch (fmd_format) {
            case ANSI_378_2004: {
                if (0 == fmd_data[8] && 0 == fmd_data[9]) {
                    nViewCnt = fmd_data[28];
                    break;
                }
                nViewCnt = fmd_data[24];
                break;
            }
            case ISO_19794_2_2005: {
                nViewCnt = fmd_data[22];
                break;
            }
            case DP_PRE_REG_FEATURES: 
            case DP_REG_FEATURES: 
            case DP_VER_FEATURES: {
                nViewCnt = 1;
            }
        }
        if (0 == nViewCnt) {
            throw new UareUException(96075977);
        }
        int fmd_fmt = Dpfj.fromFmdFormat(fmd_format);
        int result = this.DpfjImportFmd(fmd_fmt, fmd_data, fmd_fmt_to = Dpfj.fromFmdFormat(fmd_format_to), fmd_to = new FmdImpl(fmd_format_to, nViewCnt));
        if (0 != result) {
            throw new UareUException(result);
        }
        return fmd_to;
    }

    public Fid import_dp_fid(byte[] data, Fid.Format fid_format_to, int fid_dpi, boolean rotate180) throws UareUException {
        FidImpl fid;
        int fid_fmt_to = Dpfj.fromFidFormat(fid_format_to);
        int result = this.DpfjImportDpFid(data, fid_fmt_to, fid_dpi, rotate180 ? 1 : 0, fid = new FidImpl(fid_format_to, 1));
        if (0 != result) {
            throw new UareUException(result);
        }
        return fid;
    }

    public Fid import_fid(byte[] data, Fid.Format format) throws UareUException {
        FidImpl fid;
        byte nViewCnt = 0;
        switch (format) {
            case ANSI_381_2004: {
                nViewCnt = data[22];
                break;
            }
            case ISO_19794_4_2005: {
                nViewCnt = data[18];
            }
        }
        if (0 == nViewCnt) {
            throw new UareUException(96075877);
        }
        int fid_fmt = Dpfj.fromFidFormat(format);
        int result = this.DpfjImportFid(data, fid_fmt, fid = new FidImpl(format, nViewCnt));
        if (0 != result) {
            throw new UareUException(result);
        }
        return fid;
    }

    public Fmd create_fmd_from_raw(byte[] data, int width, int height, int dpi, int finger_position, int cbeff_id, Fmd.Format fmd_format) throws UareUException {
        FmdImpl fmd;
        int format = Dpfj.fromFmdFormat(fmd_format);
        int result = this.DpfjCreateFmdFromRaw(data, width, height, dpi, finger_position, cbeff_id, format, fmd = new FmdImpl(fmd_format, 1));
        if (0 != result) {
            throw new UareUException(result);
        }
        return fmd;
    }

    public Fmd create_fmd_from_fid(Fid fid, Fmd.Format fmd_format) throws UareUException {
        int fmd_fmt = Dpfj.fromFmdFormat(fmd_format);
        int fid_fmt = Dpfj.fromFidFormat(fid.getFormat());
        int view_cnt = fid.getViews().length;
        FmdImpl fmd = new FmdImpl(fmd_format, fid.getViews().length);
        int result = this.DpfjCreateFmdFromFid(fid.getData(), fid_fmt, view_cnt, fmd_fmt, fmd);
        if (0 != result) {
            throw new UareUException(result);
        }
        return fmd;
    }

    public int compare(Fmd fmd1, int view_index1, Fmd fmd2, int view_index2) throws UareUException {
        int fmt1 = Dpfj.fromFmdFormat(fmd1.getFormat());
        int fmt2 = Dpfj.fromFmdFormat(fmd2.getFormat());
        IntReference objScore = new IntReference(0);
        int result = this.DpfjCompare(fmd1.getData(), fmt1, view_index1, fmd2.getData(), fmt2, view_index2, objScore);
        if (0 != result) {
            throw new UareUException(result);
        }
        return objScore.value;
    }

    public Engine.Candidate[] identify(Fmd fmd1, int view_index1, Fmd[] fmds, int threshold, int candidates_req) throws UareUException {
        int fmt1 = Dpfj.fromFmdFormat(fmd1.getFormat());
        Object fmds_data = null;
        int fmt2 = -1;
        if (null != fmds && 0 != fmds.length) {
            fmds_data = new byte[fmds.length][];
            for (int i = 0; i < fmds.length; ++i) {
                fmds_data[i] = fmds[i].getData();
            }
            fmt2 = Dpfj.fromFmdFormat(fmds[0].getFormat());
        }
        Engine.Candidate[] candidates = new Engine.Candidate[candidates_req];
        for (int i = 0; i < candidates_req; ++i) {
            candidates[i] = new Engine.Candidate();
        }
        IntReference objCandidatesReq = new IntReference(candidates_req);
        int result = this.DpfjIdentify(fmd1.getData(), fmt1, view_index1, (byte[][])fmds_data, fmt2, threshold, objCandidatesReq, candidates);
        if (0 != result) {
            throw new UareUException(result);
        }
        Engine.Candidate[] candidates_res = new Engine.Candidate[objCandidatesReq.value];
        for (int i = 0; i < objCandidatesReq.value; ++i) {
            candidates_res[i] = candidates[i];
        }
        candidates = null;
        return candidates_res;
    }

    public void start_enrollment(Fmd.Format fmd_format) throws UareUException {
        int fmt = Dpfj.fromFmdFormat(fmd_format);
        int result = this.DpfjStartEnrollment(fmt);
        if (0 != result) {
            throw new UareUException(result);
        }
        this.m_enrollment_fmd_format = fmd_format;
    }

    public boolean add_to_enrollment(Fmd fmd, int view_index) throws UareUException {
        int fmt = Dpfj.fromFmdFormat(fmd.getFormat());
        int result = this.DpfjAddToEnrollment(fmd.getData(), fmt, view_index);
        if (0 != result && 96075789 != result) {
            throw new UareUException(result);
        }
        return 96075789 != result;
    }

    public Fmd create_enrollment_fmd() throws UareUException {
        FmdImpl fmd = new FmdImpl(this.m_enrollment_fmd_format, 1);
        int fmt = Dpfj.fromFmdFormat(this.m_enrollment_fmd_format);
        int result = this.DpfjCreateEnrollmentFmd(fmt, fmd);
        if (0 != result) {
            throw new UareUException(result);
        }
        return fmd;
    }

    public void finish_enrollment() throws UareUException {
        int result = this.DpfjFinishEnrollment();
        if (0 != result) {
            throw new UareUException(result);
        }
    }

    private static int fromFidFormat(Fid.Format fmt) {
        switch (fmt) {
            case ANSI_381_2004: {
                return 1770497;
            }
            case ISO_19794_4_2005: {
                return 0x1010007;
            }
        }
        return 0;
    }

    private static int fromFmdFormat(Fmd.Format fmt) {
        switch (fmt) {
            case ANSI_378_2004: {
                return 0x1B0001;
            }
            case ISO_19794_2_2005: {
                return 0x1010001;
            }
            case DP_PRE_REG_FEATURES: {
                return 0;
            }
            case DP_REG_FEATURES: {
                return 1;
            }
            case DP_VER_FEATURES: {
                return 2;
            }
        }
        return -1;
    }

    private class IntReference {
        protected int value;

        protected IntReference(int n) {
            this.value = n;
        }
    }
}

