/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.dockbar;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.flexdock.dockbar.DockbarLabel;
import org.flexdock.dockbar.DockbarManager;
import org.flexdock.docking.Dockable;
import org.flexdock.plaf.common.border.SlideoutBorder;

public class Dockbar
extends JPanel {
    private int orientation;
    private DockbarManager manager;
    private ArrayList mDocks = new ArrayList();

    public static int getValidOrientation(int orient) {
        switch (orient) {
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 3: {
                return 3;
            }
        }
        return 2;
    }

    public Dockbar(DockbarManager manager, int orientation) {
        this.manager = manager;
        this.setBorder(new SlideoutBorder());
        this.setOrientation(orientation);
    }

    void undock(Dockable dockable) {
        DockbarLabel label = this.getLabel(dockable);
        this.remove(label);
        this.mDocks.remove(label);
        this.getParent().validate();
        this.repaint();
    }

    public DockbarLabel getLabel(Dockable dockable) {
        if (dockable == null) {
            return null;
        }
        Iterator docks = this.mDocks.iterator();
        while (docks.hasNext()) {
            DockbarLabel label = (DockbarLabel)docks.next();
            if (label.getDockable() != dockable) continue;
            return label;
        }
        return null;
    }

    public boolean contains(Dockable dockable) {
        return this.getLabel(dockable) != null;
    }

    public void dock(Dockable dockable) {
        if (dockable == null) {
            return;
        }
        DockbarLabel currentLabel = this.getLabel(dockable);
        if (currentLabel != null) {
            currentLabel.setActive(false);
            return;
        }
        DockbarLabel newLabel = new DockbarLabel(dockable.getPersistentId(), this.getOrientation());
        this.add(newLabel);
        this.mDocks.add(newLabel);
        this.getParent().validate();
        this.repaint();
    }

    public int getOrientation() {
        return this.orientation;
    }

    private void setOrientation(int orientation) {
        this.orientation = orientation = Dockbar.getValidOrientation(orientation);
        Border border = this.getBorder();
        if (border instanceof SlideoutBorder) {
            ((SlideoutBorder)border).setOrientation(orientation);
        }
        int boxConstraint = orientation == 1 || orientation == 3 ? 2 : 3;
        this.setLayout(new BoxLayout(this, boxConstraint));
    }

    public Dimension getPreferredSize() {
        if (this.mDocks.size() == 0) {
            return new Dimension(0, 0);
        }
        DockbarLabel label = (DockbarLabel)this.getComponent(0);
        return label.getPreferredSize();
    }

    void activate(String dockableId, boolean lock) {
        if (this.manager != null) {
            this.manager.setActiveDockable(dockableId);
            if (lock) {
                this.manager.getActivationListener().lockViewpane();
            }
        }
    }

    static {
        Class clazz = DockbarLabel.class;
    }
}

