/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

import com.topaz.sigplus.util.SigDataPoint;
import com.topaz.sigplus.util.SigDataType;
import com.topaz.sigplus.util.SigDrawParameters;
import com.topaz.sigplus.util.SigGraphics;
import com.topaz.sigplus.util.SigInfo;
import com.topaz.sigplus.util.TabletParameters;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;

public class SigDrawType
extends Canvas {
    private static final double Pi = 3.14159;
    private static final double RadPerDegree = 0.017453277777777776;
    private static final int NoJustify = 0;
    private static final int AutoJustify = 1;
    private static final int JustifyUpperLeft = 2;
    private static final int JustifyUpperRight = 3;
    private static final int JustifyLowerRight = 4;
    private static final int JustifyLowerLeft = 5;
    private static final int JustifyScale = 6;
    private SigDataType sig;
    private TabletParameters tabParams;
    private SigInfo sigData;
    private static final int JustifyMask = 15;
    private static final int JustifyOverride = 16;
    private float drawZoom;

    public SigDrawType(SigDataType newSig, TabletParameters newParams) {
        this.sig = newSig;
        this.tabParams = newParams;
        this.sigData = new SigInfo();
        this.drawZoom = 1.0f;
        this.sig.getSigData(this.sigData);
        if (this.sigData.numPoints != 0) {
            this.sig.setLastPointDrawn(this.sigData.numPoints - 1);
        } else {
            this.sig.setLastPointDrawn(0);
        }
    }

    public void update(Graphics g, SigDrawParameters params, int tabletState) {
        if (this.sig == null) {
            super.update(g);
        } else {
            this.paint(g, params, tabletState);
        }
    }

    public void paint(Graphics g, SigDrawParameters params, int tabletState) {
        double yScale;
        double xScale;
        double yOffset;
        double xOffset;
        double angle;
        SigGraphics g2D = new SigGraphics(g);
        if (this.sig == null) {
            return;
        }
        int lastPointDrawn = this.sig.getSigData(this.sigData);
        g.setColor(Color.black);
        if (tabletState == 0 || lastPointDrawn == this.sigData.numPoints - 1) {
            if (!params.drawTransparentMode) {
                g.setColor(Color.white);
                g.fillRect(0, 0, params.drawXSize, params.drawYSize);
                g.setColor(Color.black);
            }
            g2D.drawTimeStamp(this.sig, params);
            g2D.drawAnnotation(this.sig, params);
        }
        switch (params.drawRotation) {
            case 90: {
                angle = this.degreesToRad(90.0);
                xOffset = this.tabParams.tabletLogicalYSize;
                yOffset = 0.0;
                xScale = (double)params.drawXSize / (double)this.tabParams.tabletLogicalYSize;
                yScale = (double)params.drawYSize / (double)this.tabParams.tabletLogicalXSize;
                break;
            }
            case 180: {
                angle = this.degreesToRad(180.0);
                xOffset = this.tabParams.tabletLogicalXSize;
                yOffset = this.tabParams.tabletLogicalYSize;
                xScale = (double)params.drawXSize / (double)this.tabParams.tabletLogicalXSize;
                yScale = (double)params.drawYSize / (double)this.tabParams.tabletLogicalYSize;
                break;
            }
            case 270: {
                angle = this.degreesToRad(270.0);
                xOffset = 0.0;
                yOffset = this.tabParams.tabletLogicalXSize;
                xScale = (double)params.drawXSize / (double)this.tabParams.tabletLogicalYSize;
                yScale = (double)params.drawYSize / (double)this.tabParams.tabletLogicalXSize;
                break;
            }
            default: {
                angle = this.degreesToRad(0.0);
                xOffset = 0.0;
                yOffset = 0.0;
                xScale = (double)params.drawXSize / (double)this.tabParams.tabletLogicalXSize;
                yScale = (double)params.drawYSize / (double)this.tabParams.tabletLogicalYSize;
            }
        }
        if ((tabletState == 1 || params.drawJustifyMode == 0) && (params.drawJustifyMode & 0x10) == 0) {
            g2D.scale(xScale, yScale);
        } else {
            this.applyJustifyMode(g2D, params);
        }
        g2D.translate(xOffset, yOffset);
        g2D.rotate(angle);
        this.drawSig(g2D, params, lastPointDrawn);
    }

    void drawSig(SigGraphics g2D, SigDrawParameters params, int lastPointDrawn) {
        int firstPoint;
        int firstStroke;
        if (g2D == null) {
            System.out.println("g2D null");
            return;
        }
        g2D.setPenWidth(params.drawPenWidth / this.drawZoom);
        if (this.sigData.strokeData == null || this.sigData.pointData == null) {
            return;
        }
        int numStrokes = this.sigData.numStrokes;
        if (numStrokes == 0) {
            return;
        }
        int[] strokes = new int[numStrokes];
        int[] strokeSize = new int[numStrokes];
        int i = 0;
        while (i < numStrokes) {
            strokes[i] = (Integer)this.sigData.strokeData.elementAt(i);
            ++i;
        }
        i = 0;
        while (i < numStrokes - 1) {
            strokeSize[i] = strokes[i + 1] - strokes[i];
            ++i;
        }
        strokeSize[i] = this.sigData.numPoints - strokes[i];
        if (lastPointDrawn == this.sigData.numPoints - 1) {
            firstStroke = 0;
            firstPoint = 0;
        } else {
            firstStroke = this.sig.getStrokeForPoint(lastPointDrawn);
            firstPoint = lastPointDrawn > 0 ? lastPointDrawn - strokes[firstStroke] : 0;
        }
        i = firstStroke;
        while (i < numStrokes) {
            int startPoint;
            if (i == firstStroke) {
                startPoint = firstPoint;
                if (startPoint < 0) {
                    startPoint = 0;
                }
            } else {
                startPoint = 0;
            }
            int j = startPoint;
            while (j < strokeSize[i] - 1) {
                SigDataPoint a = (SigDataPoint)this.sigData.pointData.elementAt(strokes[i] + j);
                SigDataPoint b = (SigDataPoint)this.sigData.pointData.elementAt(strokes[i] + j + 1);
                g2D.drawLine(a.xd, a.yd, b.xd, b.yd);
                ++j;
            }
            ++i;
        }
        this.sig.setLastPointDrawn(this.sigData.numPoints - 1);
    }

    double degreesToRad(double degrees) {
        return degrees * 0.017453277777777776;
    }

    void applyJustifyMode(SigGraphics g2D, SigDrawParameters params) {
        double yB;
        double xB;
        double yA;
        double xA;
        SigDataPoint pnt;
        SigInfo info = new SigInfo();
        int justifyMode = params.drawJustifyMode & 0xF;
        if (justifyMode == 0) {
            return;
        }
        this.sig.getSigData(info);
        int maxX = 0;
        int maxY = 0;
        if (info.numPoints == 0) {
            return;
        }
        int i = 0;
        while (i < info.numPoints) {
            pnt = (SigDataPoint)info.pointData.elementAt(i);
            if (pnt.x > maxX) {
                maxX = pnt.x;
            }
            if (pnt.y > maxY) {
                maxY = pnt.y;
            }
            ++i;
        }
        int minX = maxX;
        int minY = maxY;
        i = 0;
        while (i < info.numPoints) {
            pnt = (SigDataPoint)info.pointData.elementAt(i);
            if (pnt.x < minX) {
                minX = pnt.x;
            }
            if (pnt.y < minY) {
                minY = pnt.y;
            }
            ++i;
        }
        double xExt = maxX - minX;
        double yExt = maxY - minY;
        if (xExt == 0.0 || yExt == 0.0) {
            return;
        }
        double xGain = (double)params.drawXSize / (xExt + (double)params.drawJustifyX * 2.0);
        double yGain = (double)params.drawYSize / (yExt + (double)params.drawJustifyY * 2.0);
        double gain = xGain < yGain ? xGain : yGain;
        double displayXSize = (double)params.drawXSize / gain;
        double displayYSize = (double)params.drawYSize / gain;
        switch (justifyMode) {
            case 1: {
                xA = (double)minX - (displayXSize - xExt) / 2.0;
                yA = (double)minY - (displayYSize - yExt) / 2.0;
                xB = (double)maxX + (displayXSize - xExt) / 2.0;
                yB = (double)maxY + (displayYSize - yExt) / 2.0;
                break;
            }
            case 2: {
                xA = (double)minX - (double)params.drawJustifyX;
                yA = (double)minY - (double)params.drawJustifyY;
                xB = (double)maxX + (double)params.drawJustifyX;
                yB = (double)maxY + (double)params.drawJustifyY;
                break;
            }
            case 3: {
                xA = (double)minX - (displayXSize - (xExt + (double)params.drawJustifyX));
                yA = (double)minY - (double)params.drawJustifyY;
                xB = (double)maxX + (double)params.drawJustifyX;
                yB = (double)maxY + (double)params.drawJustifyY;
                break;
            }
            case 4: {
                xA = (double)minX - (displayXSize - (xExt + (double)params.drawJustifyX));
                yA = (double)minY - (displayYSize - (yExt + (double)params.drawJustifyY));
                xB = (double)maxX + (double)params.drawJustifyX;
                yB = (double)maxY + (double)params.drawJustifyY;
                break;
            }
            case 5: {
                xA = (double)minX - (double)params.drawJustifyX;
                yA = (double)minY - (displayYSize - (yExt + (double)params.drawJustifyY));
                xB = (double)maxX + (displayXSize - (xExt + (double)params.drawJustifyX));
                yB = (double)maxY + (double)params.drawJustifyY;
                break;
            }
            case 6: {
                xA = minX;
                yA = minY;
                double xSize = (double)params.drawJustifyX * (double)this.tabParams.tabletResolution / 1000.0;
                double ySize = xSize * (double)params.drawYSize / (double)params.drawJustifyX;
                xB = xA + xSize;
                yB = yA + ySize;
                gain = (double)params.drawXSize / xSize;
                break;
            }
            default: {
                return;
            }
        }
        this.applyJustify(g2D, params, gain, xA, yA, xB, yB);
    }

    void applyJustify(SigGraphics g2D, SigDrawParameters params, double gain, double xA, double yA, double xB, double yB) {
        double yTrans;
        double xTrans;
        this.drawZoom = (float)gain;
        g2D.scale(gain, gain);
        switch (params.drawRotation) {
            case 90: {
                xTrans = -((double)this.tabParams.tabletLogicalXSize - yB);
                yTrans = -xA;
                break;
            }
            case 180: {
                xTrans = -((double)this.tabParams.tabletLogicalXSize - xB);
                yTrans = -((double)this.tabParams.tabletLogicalYSize - yB);
                break;
            }
            case 270: {
                xTrans = -yA;
                yTrans = -((double)this.tabParams.tabletLogicalYSize - xB);
                break;
            }
            default: {
                xTrans = -xA;
                yTrans = -yA;
            }
        }
        g2D.translate(xTrans, yTrans);
    }

    public String getPdfString(SigDrawParameters params) {
        int firstStroke;
        double yScale;
        double xScale;
        double yOffset;
        double xOffset;
        double angle;
        SigGraphics g2D = new SigGraphics(null);
        SigDrawParameters pdfParams = params.copy();
        String result = new String();
        SigDataPoint oldPoint = null;
        pdfParams.drawXSize *= 10;
        pdfParams.drawYSize *= 10;
        switch (pdfParams.drawRotation) {
            case 90: {
                angle = this.degreesToRad(90.0);
                xOffset = this.tabParams.tabletLogicalYSize;
                yOffset = 0.0;
                xScale = (double)pdfParams.drawXSize / (double)this.tabParams.tabletLogicalYSize;
                yScale = (double)pdfParams.drawYSize / (double)this.tabParams.tabletLogicalXSize;
                break;
            }
            case 180: {
                angle = this.degreesToRad(180.0);
                xOffset = this.tabParams.tabletLogicalXSize;
                yOffset = this.tabParams.tabletLogicalYSize;
                xScale = (double)pdfParams.drawXSize / (double)this.tabParams.tabletLogicalXSize;
                yScale = (double)pdfParams.drawYSize / (double)this.tabParams.tabletLogicalYSize;
                break;
            }
            case 270: {
                angle = this.degreesToRad(270.0);
                xOffset = 0.0;
                yOffset = this.tabParams.tabletLogicalXSize;
                xScale = (double)pdfParams.drawXSize / (double)this.tabParams.tabletLogicalYSize;
                yScale = (double)pdfParams.drawYSize / (double)this.tabParams.tabletLogicalXSize;
                break;
            }
            default: {
                angle = this.degreesToRad(0.0);
                xOffset = 0.0;
                yOffset = 0.0;
                xScale = (double)pdfParams.drawXSize / (double)this.tabParams.tabletLogicalXSize;
                yScale = (double)pdfParams.drawYSize / (double)this.tabParams.tabletLogicalYSize;
            }
        }
        if (pdfParams.drawJustifyMode == 0) {
            g2D.scale(xScale, yScale);
        } else {
            this.applyJustifyMode(g2D, pdfParams);
        }
        g2D.translate(xOffset, yOffset);
        g2D.rotate(angle);
        if (this.sigData.strokeData == null || this.sigData.pointData == null) {
            return null;
        }
        int numStrokes = this.sigData.numStrokes;
        if (numStrokes == 0) {
            return null;
        }
        int widthInt = (int)pdfParams.drawPenWidth / 2;
        int widthFrac = pdfParams.drawPenWidth % 2.0f == 1.0f ? 5 : 0;
        result = "q " + widthInt + "." + widthFrac + " w 0 g ";
        int[] strokes = new int[numStrokes];
        int[] strokeSize = new int[numStrokes];
        int i = 0;
        while (i < numStrokes) {
            strokes[i] = (Integer)this.sigData.strokeData.elementAt(i);
            ++i;
        }
        i = 0;
        while (i < numStrokes - 1) {
            strokeSize[i] = strokes[i + 1] - strokes[i];
            ++i;
        }
        strokeSize[i] = this.sigData.numPoints - strokes[i];
        i = firstStroke = 0;
        while (i < numStrokes) {
            int startPoint;
            int j = startPoint = 0;
            while (j < strokeSize[i] - 1) {
                SigDataPoint a = (SigDataPoint)this.sigData.pointData.elementAt(strokes[i] + j);
                int x = g2D.transformX(a.xd, a.yd);
                int y = g2D.transformY(a.xd, a.yd);
                y = pdfParams.drawYSize - y;
                if (j == 0) {
                    result = String.valueOf(result) + x / 10 + "." + x % 10 + " " + y / 10 + "." + y % 10 + " m ";
                    oldPoint = a;
                } else if (a != oldPoint) {
                    result = String.valueOf(result) + x / 10 + "." + x % 10 + " " + y / 10 + "." + y % 10 + " l ";
                    oldPoint = a;
                }
                ++j;
            }
            ++i;
        }
        result = String.valueOf(result) + "S Q";
        return result;
    }
}

