/*
 * Decompiled with CFR 0.152.
 */
package com.topaz.sigplus.util;

import com.topaz.sigplus.util.LCDWindowedCmdType;
import com.topaz.sigplus.util.SigDataType;
import com.topaz.sigplus.util.SigUsb;
import com.topaz.sigplus.util.TabletParameters;
import com.topaz.sigplus.util.TabletPoint;
import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import java.util.Vector;

public class TabletInterface
implements Runnable,
SerialPortEventListener {
    private static final int MaxFilterPoints = 16;
    private int penState;
    private TabletPoint lastPoint;
    private Vector savedSamples;
    private TabletPoint[] filter;
    int nextFilterPoint;
    private SigDataType theSig;
    public TabletParameters params;
    volatile boolean timeToDie;
    static CommPortIdentifier portId;
    static Enumeration portList;
    InputStream inputStream;
    OutputStream outputStream;
    SerialPort serialPort;
    Thread readThread;
    byte[] inputBuffer;
    int inputBufferSize;
    int inputBufferHead;
    int inputBufferTail;
    boolean tabletStatus;
    byte[] readBuffer;
    static final int WaitingForNear = 0;
    static final int NearWaitingForPenDown = 1;
    static final int PenDownState = 2;
    static final int PenUpState = 3;
    static final int LCDCapNone = 0;
    static final int LCDCapDefault = 1;
    static final int LCDCapInk = 2;
    static final int LCDCapInkInvert = 3;
    static final byte LCDDefaultCmd = 4;
    static final byte LCDInkCmd = 20;
    static final byte LCDInkInvertCmd = 9;
    static final byte LCDKeyPadCmd = 11;
    static final byte LCDWriteDisplayCmd = 7;
    static final byte LCDWriteHiddenCmd = 23;
    static final byte LCDRefreshCmd = 18;
    static final byte LCDQuietCmd = 17;
    static final int LCDDestFore = 0;
    static final int LCDDestBack = 1;
    boolean serialTablet;
    SigUsb sigUsbInterface;
    static final int USBPenDown = 8;
    static final int USBPenNear = 4;
    boolean usbTablet;
    public int badPointCounter;
    boolean hidTablet;
    static final int LCDRetryCount = 2;
    static final int LCDWriteDelay = 10;
    long modelNumber;
    byte[] nonPointCmdBuffer;
    int nonPointCmdBytes;
    int serialInputState;
    long serialNumber;
    private static final int SigSocketPort = 47289;
    static final int SigSockLCDStream = 1;
    static final int SigSockTabletData = 0;
    boolean socketTablet;
    static final int StatusCmdData = 3;
    static final int StatusSerialNoData = 2;
    Socket tabletSocket;
    static final int WaitForRestOfPacket = 2;
    static final int WaitForSecondByte = 1;
    static final int WaitForStartByte = 0;
    int compBufferSize;
    long currentPressure;

    public TabletInterface(TabletParameters newParams, SigDataType newSig) {
        this.params = newParams;
        this.theSig = newSig;
        this.penState = 0;
        this.lastPoint = new TabletPoint();
        this.savedSamples = new Vector();
        this.filter = new TabletPoint[16];
        this.nextFilterPoint = 0;
        this.inputBufferSize = 8192;
        this.inputBufferHead = 0;
        this.inputBufferTail = 0;
        this.inputBuffer = new byte[this.inputBufferSize];
        this.readBuffer = new byte[this.inputBufferSize];
        this.serialTablet = false;
        this.usbTablet = false;
        this.sigUsbInterface = null;
        this.serialNumber = 0L;
        this.modelNumber = 0L;
        this.nonPointCmdBuffer = new byte[32];
        this.nonPointCmdBytes = 0;
        this.badPointCounter = 0;
        this.currentPressure = 0L;
    }

    public boolean openTablet() {
        String typeOfTab = this.params.tabletComPort.substring(0, 3);
        boolean rv = false;
        this.serialTablet = false;
        this.usbTablet = false;
        this.hidTablet = false;
        this.socketTablet = false;
        this.sleep(1);
        if (typeOfTab.equals("USB")) {
            rv = this.openTabletUsb();
            if (rv) {
                this.usbTablet = true;
            }
        } else if (typeOfTab.equals("HID")) {
            rv = this.openTabletUsb();
            if (rv) {
                this.hidTablet = true;
            }
        } else if (typeOfTab.equals("NET")) {
            rv = this.openTabletSocket();
            if (rv) {
                this.socketTablet = true;
            }
        } else {
            rv = this.openTabletSerial();
            if (rv) {
                this.serialTablet = true;
            }
        }
        if (rv) {
            this.tabletStatus = true;
            this.timeToDie = false;
            this.readThread = new Thread(this);
            this.readThread.start();
            this.readThread.setPriority(this.readThread.getPriority() + 1);
            this.sleep(1);
        }
        return rv;
    }

    public boolean closeTablet() {
        if (!this.tabletStatus) {
            return false;
        }
        if (this.serialTablet) {
            try {
                this.inputStream.close();
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serialPort.close();
            this.timeToDie = true;
            this.tabletStatus = false;
            while (this.timeToDie) {
                this.sleep(1);
            }
            return true;
        }
        if (this.usbTablet || this.hidTablet) {
            this.sigUsbInterface.closeUsbPort();
            this.timeToDie = true;
            this.tabletStatus = false;
            while (this.timeToDie) {
                this.sleep(1);
            }
            return true;
        }
        if (this.socketTablet) {
            try {
                this.inputStream.close();
                this.outputStream.close();
                this.tabletSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.timeToDie = true;
            this.tabletStatus = false;
            while (this.timeToDie) {
                this.sleep(1);
            }
            return true;
        }
        return false;
    }

    public void run() {
        if (this.usbTablet) {
            this.processUsbInput();
        } else if (this.serialTablet) {
            this.processSerialInput();
        } else if (this.hidTablet) {
            this.processHidInput();
        } else if (this.socketTablet) {
            this.processSocketInput();
        }
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 1: {
                try {
                    while (this.inputStream.available() > 0) {
                        int numBytes = this.inputStream.read(this.readBuffer);
                        this.addToInputBuffer(this.readBuffer, numBytes);
                    }
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    synchronized void addToInputBuffer(byte[] inBuff, int numBytes) {
        int i = 0;
        while (i < numBytes) {
            this.inputBuffer[this.inputBufferTail] = inBuff[i];
            int tempTail = this.inputBufferTail;
            if (++tempTail == this.inputBufferSize) {
                tempTail = 0;
            }
            if (tempTail != this.inputBufferHead) {
                this.inputBufferTail = tempTail;
            }
            ++i;
        }
    }

    synchronized int bytesInInputBuffer() {
        int count = this.inputBufferTail - this.inputBufferHead;
        if (count < 0) {
            return count + this.inputBufferSize;
        }
        return count;
    }

    synchronized byte getFromInputBuffer() {
        if (this.inputBufferHead == this.inputBufferTail) {
            return 0;
        }
        byte value = this.inputBuffer[this.inputBufferHead++];
        if (this.inputBufferHead == this.inputBufferSize) {
            this.inputBufferHead = 0;
        }
        return value;
    }

    boolean isStartByte(byte value) {
        return (value & 0x80) != 0;
    }

    int convertCoordData(byte lsb, byte msb) {
        int pos = msb;
        pos &= 0x1F;
        pos <<= 7;
        return pos += lsb & 0x7F;
    }

    boolean isPenDown(int status) {
        return (status & 1) != 0;
    }

    int setPenDown(int status) {
        return status | 1;
    }

    boolean isPenNear(int status) {
        return (status & 0x40) != 0;
    }

    int setPenNear(int status) {
        return status | 0x40;
    }

    boolean isBadPacket(byte[] buffer) {
        if ((buffer[1] & 0x80) != 0 || (buffer[2] & 0xE0) != 0 || (buffer[3] & 0x80) != 0 || (buffer[4] & 0xE0) != 0) {
            return true;
        }
        if ((buffer[1] & 0x7F) == 127 && (buffer[2] & 0x1F) == 31 && (buffer[3] & 0x7F) == 127 && (buffer[4] & 0x1F) == 31) {
            ++this.badPointCounter;
            return true;
        }
        return false;
    }

    void scaleCoordData(TabletPoint tPoint) {
        int newX;
        int newY;
        switch (this.params.getTabletRotationMode()) {
            case 90: {
                newY = tPoint.x - this.params.tabletXStart;
                newY *= this.params.tabletLogicalYSize;
                newY /= this.params.tabletXStop - this.params.tabletXStart;
                newX = tPoint.y - this.params.tabletYStop;
                newX *= this.params.tabletLogicalXSize;
                newX /= this.params.tabletYStart - this.params.tabletYStop;
                break;
            }
            case 180: {
                newX = tPoint.x - this.params.tabletXStop;
                newX *= this.params.tabletLogicalXSize;
                newX /= this.params.tabletXStart - this.params.tabletXStop;
                newY = tPoint.y - this.params.tabletYStop;
                newY *= this.params.tabletLogicalYSize;
                newY /= this.params.tabletYStart - this.params.tabletYStop;
                break;
            }
            case 270: {
                newY = tPoint.x - this.params.tabletXStop;
                newY *= this.params.tabletLogicalYSize;
                newY /= this.params.tabletXStart - this.params.tabletXStop;
                newX = tPoint.y - this.params.tabletYStart;
                newX *= this.params.tabletLogicalXSize;
                newX /= this.params.tabletYStop - this.params.tabletYStart;
                break;
            }
            default: {
                newX = tPoint.x - this.params.tabletXStart;
                newX *= this.params.tabletLogicalXSize;
                newX /= this.params.tabletXStop - this.params.tabletXStart;
                newY = tPoint.y - this.params.tabletYStart;
                newY *= this.params.tabletLogicalYSize;
                newY /= this.params.tabletYStop - this.params.tabletYStart;
            }
        }
        if (newX < 0) {
            newX = 0;
        }
        if (newX > this.params.tabletLogicalXSize) {
            newX = this.params.tabletLogicalXSize;
        }
        tPoint.x = newX;
        if (newY < 0) {
            newY = 0;
        }
        if (newY > this.params.tabletLogicalYSize) {
            newY = this.params.tabletLogicalYSize;
        }
        tPoint.y = newY;
    }

    void processTabletSample(TabletPoint tPoint) {
        boolean inSigWindowNew = this.theSig.isInSigWindow(tPoint.x, tPoint.y);
        boolean inSigWindowOld = this.theSig.isInSigWindow(this.lastPoint.x, this.lastPoint.y);
        switch (this.penState) {
            case 0: {
                if (!this.isPenNear(tPoint.status) && !this.isPenDown(tPoint.status)) break;
                this.penState = 1;
                break;
            }
            case 1: {
                if (this.isPenDown(tPoint.status)) {
                    TabletPoint samp;
                    this.penState = 2;
                    this.savedSamples.addElement(tPoint);
                    while (this.savedSamples.size() > 0) {
                        samp = (TabletPoint)this.savedSamples.elementAt(0);
                        this.savedSamples.removeElementAt(0);
                        if (this.onPenDown(samp)) break;
                    }
                    while (this.savedSamples.size() > 0) {
                        samp = (TabletPoint)this.savedSamples.elementAt(0);
                        this.savedSamples.removeElementAt(0);
                        this.onPenMove(samp);
                    }
                } else {
                    if (!this.isPenNear(tPoint.status)) {
                        this.penState = 0;
                        break;
                    }
                    this.savedSamples.addElement(tPoint);
                    while (this.savedSamples.size() > this.params.tabletTimingAdvance) {
                        this.savedSamples.removeElementAt(0);
                    }
                }
                break;
            }
            case 2: {
                if (inSigWindowOld || inSigWindowNew) {
                    if (inSigWindowNew && !inSigWindowOld) {
                        this.onPenDown(tPoint);
                        break;
                    }
                    if (!inSigWindowNew && inSigWindowOld) {
                        this.penState = 3;
                        this.onPenUp(tPoint);
                        break;
                    }
                }
                if (!this.isPenDown(tPoint.status)) {
                    this.penState = 3;
                    this.onPenUp(tPoint);
                    break;
                }
                if (!this.samplesAreDifferent(tPoint, this.lastPoint)) break;
                this.onPenMove(tPoint);
                break;
            }
            case 3: {
                if (this.isPenDown(tPoint.status)) {
                    this.penState = 2;
                    this.onPenDown(tPoint);
                    break;
                }
                if (this.isPenNear(tPoint.status)) break;
                this.penState = 0;
                break;
            }
        }
        this.lastPoint = tPoint;
    }

    boolean samplesAreDifferent(TabletPoint a, TabletPoint b) {
        return true;
    }

    void onPenUp(TabletPoint tPoint) {
        if (this.theSig.addHotSpotPoint(tPoint.x, tPoint.y, this.currentPressure)) {
            return;
        }
        int i = 0;
        while (i < this.params.tabletFilterPoints) {
            TabletPoint filteredPoint = this.filterPoint(tPoint);
            this.addPointToCurrentStroke(filteredPoint);
            ++i;
        }
    }

    void onPenMove(TabletPoint tPoint) {
        if (this.theSig.addHotSpotPoint(tPoint.x, tPoint.y, this.currentPressure)) {
            return;
        }
        TabletPoint filteredPoint = this.filterPoint(tPoint);
        this.addPointToCurrentStroke(filteredPoint);
    }

    void initializeFilter(TabletPoint tPoint) {
        int i = 0;
        while (i < this.params.tabletFilterPoints) {
            this.filter[i] = tPoint;
            ++i;
        }
        this.nextFilterPoint = 0;
    }

    TabletPoint filterPoint(TabletPoint tPoint) {
        TabletPoint value = new TabletPoint();
        this.filter[this.nextFilterPoint++] = tPoint;
        if (this.nextFilterPoint == this.params.tabletFilterPoints) {
            this.nextFilterPoint = 0;
        }
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.params.tabletFilterPoints) {
            x += this.filter[i].x;
            y += this.filter[i].y;
            ++i;
        }
        value.x = x / this.params.tabletFilterPoints;
        value.y = y / this.params.tabletFilterPoints;
        value.status = tPoint.status;
        return value;
    }

    void newStroke() {
        if (this.theSig != null) {
            this.theSig.addNewStroke();
        }
    }

    void addPointToCurrentStroke(TabletPoint tPoint) {
        if (this.theSig != null) {
            this.theSig.addNewPoint(tPoint.x, tPoint.y, this.currentPressure);
        }
    }

    public boolean lcdSetWindow(int xPos, int yPos, int xSize, int ySize) {
        LCDWindowedCmdType cmd = new LCDWindowedCmdType();
        cmd.setCmd((byte)11);
        cmd.setMode(0);
        cmd.setXPos(xPos);
        cmd.setYPos(yPos);
        cmd.setXSize(xSize);
        cmd.setYSize(ySize);
        boolean oldStatus = this.tabletStatus;
        if (!oldStatus) {
            this.openTablet();
        }
        boolean rv = this.lcdSendCommand(cmd);
        if (!oldStatus) {
            this.closeTablet();
        }
        return rv;
    }

    public boolean lcdRefresh(int mode, int xPos, int yPos, int xSize, int ySize) {
        LCDWindowedCmdType cmd = new LCDWindowedCmdType();
        cmd.setCmd((byte)18);
        cmd.setMode(mode);
        cmd.setXPos(xPos);
        cmd.setYPos(yPos);
        cmd.setXSize((xSize + 7) / 8 * 8);
        cmd.setYSize(ySize);
        boolean oldStatus = this.tabletStatus;
        if (!oldStatus) {
            this.openTablet();
        }
        boolean rv = this.lcdSendCommand(cmd);
        this.sleep(100);
        this.lcdTabletSetup();
        if (!oldStatus) {
            this.closeTablet();
        }
        return rv;
    }

    public void lcdTabletSetup() {
        int cmdCode;
        byte[] cmdStr = new byte[1];
        switch (this.params.getTabletLCDCaptureMode()) {
            case 1: {
                cmdCode = 4;
                break;
            }
            case 2: {
                cmdCode = 20;
                break;
            }
            case 3: {
                cmdCode = 9;
                break;
            }
            default: {
                return;
            }
        }
        cmdStr[0] = 17;
        int i = 0;
        while (i < 2) {
            int bufferBytes = this.bytesInInputBuffer();
            this.writeCommand(cmdStr);
            this.sleep(10);
            if (bufferBytes == this.bytesInInputBuffer()) break;
            ++i;
        }
        this.resetSerialInputState();
        this.resetNonPointCmdBuffer();
        cmdStr[0] = cmdCode;
        this.writeCommand(cmdStr);
        if (this.waitForNonPointCmdData(2000L, 1) && this.nonPointCmdBuffer[0] != cmdStr[0]) {
            return;
        }
    }

    public boolean lcdSendCommand(LCDWindowedCmdType cmd) {
        byte[] cmdStr = new byte[1];
        byte cSumCalc = 0;
        int i = 0;
        while (i < cmd.cmdSize) {
            cSumCalc += cmd.cmdBuffer[i];
            ++i;
        }
        cSumCalc &= 0xFF;
        cmdStr[0] = 17;
        i = 0;
        while (i < 2) {
            int bufferBytes = this.bytesInInputBuffer();
            this.writeCommand(cmdStr);
            this.sleep(10);
            if (bufferBytes == this.bytesInInputBuffer()) break;
            ++i;
        }
        this.resetSerialInputState();
        this.resetNonPointCmdBuffer();
        this.writeCommand(cmd.cmdBuffer);
        if (!this.waitForNonPointCmdData(2000L, 1)) {
            return false;
        }
        return this.nonPointCmdBuffer[0] == cSumCalc;
    }

    boolean lcdSendGraphic(int dest, int mode, int xPos, int yPos, int xSize, int ySize, byte[] bitmapData, int size) {
        byte[] compDataBuffer;
        if (this.params.tabletLCDCompressMode != 0) {
            int factor = mode == 2 ? this.params.tabletLCDFastCompressionFactor : this.params.tabletLCDSlowCompressionFactor;
            compDataBuffer = this.compressLCDGraphics(factor, bitmapData, size);
            this.compBufferSize = compDataBuffer.length;
        } else {
            compDataBuffer = bitmapData;
            this.compBufferSize = size;
        }
        LCDWindowedCmdType cmd = new LCDWindowedCmdType(this.compBufferSize);
        if (this.params.tabletLCDCompressMode != 0) {
            if (dest == 0) {
                cmd.setCmd((byte)8);
            } else {
                cmd.setCmd((byte)24);
            }
        } else if (dest == 0) {
            cmd.setCmd((byte)7);
        } else {
            cmd.setCmd((byte)23);
        }
        cmd.setMode(mode);
        cmd.setXPos(xPos);
        cmd.setYPos(yPos);
        cmd.setXSize(xSize);
        cmd.setYSize(ySize);
        cmd.setData(compDataBuffer);
        return this.lcdSendCommand(cmd);
    }

    public boolean isRI() {
        return this.serialPort.isRI();
    }

    public boolean openTabletSerial() {
        this.tabletStatus = false;
        try {
            portId = CommPortIdentifier.getPortIdentifier((String)this.params.tabletComPort);
        }
        catch (Exception e) {
            return this.tabletStatus;
        }
        try {
            this.serialPort = (SerialPort)portId.open("SigPlustabletInterface", 2000);
        }
        catch (Exception e) {
            return this.tabletStatus;
        }
        if (this.serialPort == null) {
            return this.tabletStatus;
        }
        if (this.params.tabletComTest && !this.isDSR()) {
            this.serialPort.close();
            return this.tabletStatus;
        }
        try {
            this.inputStream = this.serialPort.getInputStream();
            this.outputStream = this.serialPort.getOutputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.serialPort.addEventListener((SerialPortEventListener)this);
        }
        catch (TooManyListenersException tooManyListenersException) {
            // empty catch block
        }
        this.serialPort.notifyOnDataAvailable(true);
        try {
            this.params.getTabletBaudRate();
            this.sleep(10);
            this.serialPort.setSerialPortParams(this.params.getTabletBaudRate(), 8, 1, 1);
            this.sleep(10);
            this.serialPort.setInputBufferSize(32768);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            // empty catch block
        }
        this.tabletStatus = true;
        return this.tabletStatus;
    }

    public boolean openTabletUsb() {
        if (this.sigUsbInterface == null) {
            this.sigUsbInterface = new SigUsb();
        }
        this.tabletStatus = this.sigUsbInterface.openUsbPort(this.params.tabletComPort);
        return this.tabletStatus;
    }

    public long getTabletModelNumber() {
        byte[] cmdStr = new byte[1];
        this.modelNumber = 0L;
        cmdStr[0] = 0;
        if (this.tabletStatus) {
            this.writeCommand(cmdStr);
            this.sleep(100);
        }
        return this.modelNumber;
    }

    public long getTabletSerialNumber() {
        byte[] cmdStr = new byte[1];
        this.serialNumber = 0L;
        cmdStr[0] = 0;
        if (this.tabletStatus) {
            this.writeCommand(cmdStr);
            this.sleep(100);
        }
        return this.serialNumber;
    }

    public boolean isDSR() {
        return this.serialPort.isDSR();
    }

    public boolean isSerialPenData(byte statusByte) {
        switch (statusByte) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return true;
            }
            case 5: {
                return false;
            }
            case 6: {
                return false;
            }
            case 7: {
                return false;
            }
        }
        return false;
    }

    public byte[] lcdSendCmdString(byte[] cmdString, int returnCount, long timeOut) {
        byte[] returnData = new byte[returnCount];
        this.writeCommand(cmdString);
        if (returnCount > 0 && this.waitForNonPointCmdData(timeOut, returnCount)) {
            int i = 0;
            while (i < returnCount) {
                returnData[i] = this.nonPointCmdBuffer[i];
                ++i;
            }
            return returnData;
        }
        return null;
    }

    boolean onPenDown(TabletPoint tPoint) {
        this.initializeFilter(tPoint);
        if (this.theSig.addHotSpotPoint(tPoint.x, tPoint.y, this.currentPressure)) {
            return false;
        }
        this.newStroke();
        this.addPointToCurrentStroke(tPoint);
        return true;
    }

    public boolean openTabletSocket() {
        InetAddress tabAddress;
        String ipAddress = this.params.tabletComPort.substring(4);
        try {
            tabAddress = InetAddress.getByName(ipAddress);
        }
        catch (Exception e) {
            return false;
        }
        try {
            this.tabletSocket = new Socket(tabAddress, 47289);
        }
        catch (Exception e) {
            return false;
        }
        try {
            this.inputStream = this.tabletSocket.getInputStream();
            this.outputStream = this.tabletSocket.getOutputStream();
        }
        catch (Exception e) {
            try {
                this.tabletSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public void processHidInput() {
        byte[] scratch = new byte[5];
        byte lastByte = 0;
        int serialPacketIndex = 0;
        int pointsSinceLastSleep = 0;
        this.serialInputState = 0;
        while (true) {
            if (this.timeToDie) {
                this.timeToDie = false;
                return;
            }
            int bytesInBuffer = this.bytesInInputBuffer();
            if (bytesInBuffer == 0) {
                if (this.theSig != null) {
                    this.theSig.fireIfNewData();
                }
                this.sleep(20);
                byte[] hidData = this.sigUsbInterface.getSerialData();
                if (hidData != null && hidData.length > 0) {
                    this.addToInputBuffer(hidData, hidData.length);
                }
                if (this.serialInputState != 1) continue;
                this.processSerialCmdData(lastByte);
                this.serialInputState = 0;
                continue;
            }
            bytesInBuffer = this.bytesInInputBuffer();
            if (bytesInBuffer == 0) continue;
            byte thisByte = this.getFromInputBuffer();
            if (this.serialInputState == 0) {
                if (!this.isStartByte(thisByte)) {
                    this.processSerialCmdData(thisByte);
                    continue;
                }
                lastByte = thisByte;
                this.serialInputState = 1;
                continue;
            }
            if (this.serialInputState == 1) {
                if (this.isStartByte(thisByte)) {
                    this.processSerialCmdData(lastByte);
                    scratch[0] = thisByte;
                    serialPacketIndex = 1;
                    this.serialInputState = 2;
                    continue;
                }
                scratch[0] = lastByte;
                scratch[1] = thisByte;
                serialPacketIndex = 2;
                this.serialInputState = 2;
                continue;
            }
            if (serialPacketIndex >= 5) {
                this.serialInputState = 0;
                continue;
            }
            scratch[serialPacketIndex++] = thisByte;
            if (serialPacketIndex != 5) continue;
            this.serialInputState = 0;
            int x = this.convertCoordData(scratch[1], scratch[2]);
            int y = this.convertCoordData(scratch[3], scratch[4]);
            int status = scratch[0] & 0xFF;
            if (this.isBadPacket(scratch)) continue;
            if (!this.isSerialPenData((byte)(scratch[0] >> 2 & 7))) {
                if (this.isSerialPressureData((byte)(scratch[0] >> 2 & 7))) {
                    this.currentPressure = this.convertPressureData(scratch[3], scratch[4]);
                }
                this.sendSerialNPData(scratch[0], x, y);
                continue;
            }
            TabletPoint tPoint = new TabletPoint(x, y, status);
            this.scaleCoordData(tPoint);
            this.processTabletSample(tPoint);
            if (this.theSig != null) {
                this.theSig.fireIfNewData();
            }
            if (++pointsSinceLastSleep <= 10) continue;
            this.sleep(20);
            pointsSinceLastSleep = 0;
        }
    }

    public void processNonPointData(int statusPacketType, byte[] statusPacketData) {
        switch (statusPacketType) {
            case 2: {
                this.modelNumber = (statusPacketData[0] & 0xFC) >> 2;
                this.serialNumber = statusPacketData[0] & 3;
                this.serialNumber <<= 8;
                this.serialNumber |= (long)statusPacketData[1];
                this.serialNumber <<= 8;
                this.serialNumber |= (long)statusPacketData[2];
                this.serialNumber &= 0x3FFFFL;
                break;
            }
            case 3: {
                if (this.nonPointCmdBytes >= this.nonPointCmdBuffer.length) break;
                this.nonPointCmdBuffer[this.nonPointCmdBytes++] = statusPacketData[2];
                break;
            }
        }
    }

    public void processSerialCmdData(byte cmdByte) {
        byte[] cmdBytes = new byte[]{1, 17, cmdByte};
        this.processNonPointData(3, cmdBytes);
    }

    public void processSerialInput() {
        byte[] scratch = new byte[5];
        byte lastByte = 0;
        int serialPacketIndex = 0;
        int pointsSinceLastSleep = 0;
        this.serialInputState = 0;
        while (true) {
            if (this.timeToDie) {
                this.timeToDie = false;
                return;
            }
            int bytesInBuffer = this.bytesInInputBuffer();
            if (bytesInBuffer == 0) {
                if (this.theSig != null) {
                    this.theSig.fireIfNewData();
                }
                this.sleep(20);
                if (this.serialInputState != 1 || (bytesInBuffer = this.bytesInInputBuffer()) != 0) continue;
                this.processSerialCmdData(lastByte);
                this.serialInputState = 0;
                continue;
            }
            byte thisByte = this.getFromInputBuffer();
            if (this.serialInputState == 0) {
                if (!this.isStartByte(thisByte)) {
                    this.processSerialCmdData(thisByte);
                    continue;
                }
                lastByte = thisByte;
                this.serialInputState = 1;
                continue;
            }
            if (this.serialInputState == 1) {
                if (this.isStartByte(thisByte)) {
                    this.processSerialCmdData(lastByte);
                    scratch[0] = thisByte;
                    serialPacketIndex = 1;
                    this.serialInputState = 2;
                    continue;
                }
                scratch[0] = lastByte;
                scratch[1] = thisByte;
                serialPacketIndex = 2;
                this.serialInputState = 2;
                continue;
            }
            if (this.serialInputState != 2) continue;
            if (serialPacketIndex >= 5) {
                this.serialInputState = 0;
                continue;
            }
            scratch[serialPacketIndex++] = thisByte;
            if (serialPacketIndex != 5) continue;
            this.serialInputState = 0;
            int x = this.convertCoordData(scratch[1], scratch[2]);
            int y = this.convertCoordData(scratch[3], scratch[4]);
            int status = scratch[0] & 0xFF;
            if (this.isBadPacket(scratch)) continue;
            if (!this.isSerialPenData((byte)(scratch[0] >> 2 & 7))) {
                if (this.isSerialPressureData((byte)(scratch[0] >> 2 & 7))) {
                    this.currentPressure = this.convertPressureData(scratch[3], scratch[4]);
                    continue;
                }
                this.sendSerialNPData(scratch[0], x, y);
                continue;
            }
            TabletPoint tPoint = new TabletPoint(x, y, status);
            this.scaleCoordData(tPoint);
            this.processTabletSample(tPoint);
            if (this.theSig != null) {
                this.theSig.fireIfNewData();
            }
            if (++pointsSinceLastSleep <= 10) continue;
            this.sleep(10);
            pointsSinceLastSleep = 0;
        }
    }

    public void processSocketInput() {
        byte[] longPoint = new byte[8];
        while (true) {
            if (this.timeToDie) {
                this.timeToDie = false;
                return;
            }
            try {
                int msgType = longPoint[0] | longPoint[1] << 8 | longPoint[2] << 16 | longPoint[3] << 24;
                if (msgType != 0) continue;
                long tempHigh = longPoint[5] & 0xFF;
                long tempLow = longPoint[6] >> 4 & 0xF;
                int x = (int)(tempHigh << 4 | tempLow);
                tempHigh = longPoint[6] & 0xF;
                tempLow = longPoint[7] & 0xFF;
                int y = (int)(tempHigh << 8 | tempLow);
                byte rawStatus = longPoint[4];
                int status = 0;
                if ((rawStatus & 8) != 0) {
                    status = this.setPenDown(0);
                }
                if ((rawStatus & 4) != 0) {
                    status = this.setPenNear(status);
                }
                TabletPoint tPnt = new TabletPoint(x, y, status);
                this.processTabletSample(tPnt);
                if (this.theSig == null) continue;
                this.theSig.fireIfNewData();
            }
            catch (Exception exception) {
            }
        }
    }

    public void processUsbInput() {
        while (!this.timeToDie) {
            long longPoint = this.sigUsbInterface.getPointData();
            if (longPoint == 0L) continue;
            long tempHigh = longPoint >> 8 & 0xFFL;
            long tempLow = longPoint >> 20 & 0xFL;
            int x = (int)(tempHigh << 4 | tempLow);
            tempHigh = longPoint >> 16 & 0xFL;
            tempLow = longPoint >> 24 & 0xFFL;
            int y = (int)(tempHigh << 8 | tempLow);
            int rawStatus = (int)(longPoint & 0xFFL);
            int status = 0;
            if ((rawStatus & 8) != 0) {
                status = this.setPenDown(0);
            }
            if ((rawStatus & 4) != 0) {
                status = this.setPenNear(status);
            }
            TabletPoint tPnt = new TabletPoint(x, y, status);
            this.scaleCoordData(tPnt);
            this.processTabletSample(tPnt);
            if (this.theSig == null) continue;
            this.theSig.fireIfNewData();
        }
        return;
    }

    public void resetNonPointCmdBuffer() {
        this.nonPointCmdBytes = 0;
    }

    public synchronized void resetSerialInputState() {
        this.serialInputState = 0;
    }

    public void sendSerialNPData(byte statusByte, int xPos, int yPos) {
        byte[] cmdBytes = new byte[]{(byte)(xPos >> 4), (byte)((xPos & 0xF) << 4 | (yPos & 0xF00) >> 8), (byte)(yPos & 0xFF)};
        this.processNonPointData(statusByte >> 2 & 7, cmdBytes);
    }

    public void sleep(int timeInMs) {
        try {
            Thread.sleep(timeInMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean waitForNonPointCmdData(long timeoutInMs, int numBytes) {
        long sleepCount = timeoutInMs / 10L;
        while (this.nonPointCmdBytes < numBytes) {
            if (sleepCount-- <= 0L) {
                return false;
            }
            this.sleep(10);
        }
        return true;
    }

    public void writeCommand(byte[] cmdString) {
        if (this.serialTablet || this.socketTablet) {
            try {
                this.outputStream.write(cmdString);
                this.outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        if (this.hidTablet) {
            this.sigUsbInterface.putCmdString(cmdString);
        }
    }

    public int compressLCDData(int compressionFactor, byte[] rawData, int rawSize, byte[] compData, boolean doComp) {
        int compSize = 0;
        int ptr = 0;
        int start = 0;
        byte lastByte = rawData[0];
        boolean repeating = false;
        int count = 1;
        int i = 1;
        while (i < rawSize) {
            if (!repeating) {
                int j;
                if (rawData[i] == lastByte) {
                    if (--count >= 1) {
                        if (doComp) {
                            compData[ptr++] = (byte)count;
                            j = 0;
                            while (j < count) {
                                compData[ptr++] = rawData[start + j];
                                ++j;
                            }
                        }
                        ++compSize;
                        compSize += count;
                    }
                    start = i - 1;
                    if (i == rawSize - 1) {
                        count = 1;
                        --i;
                    } else {
                        count = 2;
                    }
                    repeating = true;
                } else {
                    lastByte = rawData[i];
                    if (++count == 127 || i == rawSize - 1) {
                        if (i != rawSize - 1 && lastByte == rawData[i + 1]) {
                            --count;
                        }
                        if (doComp) {
                            compData[ptr++] = (byte)count;
                            j = 0;
                            while (j < count) {
                                compData[ptr++] = rawData[start + j];
                                ++j;
                            }
                        }
                        ++compSize;
                        compSize += count;
                        start = i + 1;
                        count = 0;
                        if (i != rawSize - 1 && lastByte == rawData[i + 1]) {
                            start = i;
                            count = 1;
                        }
                    }
                }
            } else if (rawData[i] != lastByte) {
                if (doComp) {
                    compData[ptr++] = (byte)(count | 0x80);
                    compData[ptr++] = lastByte;
                }
                compSize += 2;
                count = 1;
                start = i;
                lastByte = rawData[i];
                if (i == rawSize - 1) {
                    if (doComp) {
                        compData[ptr++] = 1;
                        compData[ptr++] = lastByte;
                    }
                    compSize += 2;
                }
                repeating = false;
            } else if (++count == compressionFactor || i == rawSize - 1) {
                if (doComp) {
                    compData[ptr++] = (byte)(count | 0x80);
                    compData[ptr++] = lastByte;
                }
                compSize += 2;
                start = i + 1;
                count = 0;
                repeating = false;
                if (i != rawSize - 1 && lastByte == rawData[i + 1]) {
                    repeating = true;
                }
            }
            ++i;
        }
        return compSize;
    }

    public byte[] compressLCDGraphics(int compressionFactor, byte[] bitmapData, int bitmapSize) {
        byte[] buffer = new byte[1];
        this.compBufferSize = this.compressLCDData(compressionFactor, bitmapData, bitmapSize, buffer, false);
        buffer = new byte[this.compBufferSize];
        this.compBufferSize = this.compressLCDData(compressionFactor, bitmapData, bitmapSize, buffer, true);
        return buffer;
    }

    public long convertPressureData(byte lsb, byte msb) {
        int press = msb;
        press &= 7;
        press <<= 7;
        return press += lsb & 0x7F;
    }

    public void dumpBuffer(byte[] buffer, int bufferSize, String title) {
        System.out.println("Dumping Buffer " + title + "Size = " + bufferSize);
        int i = 0;
        while (i < bufferSize) {
            int v = buffer[i];
            System.out.println("Buffer[ " + i + " ]  = " + (v &= 0xFF));
            ++i;
        }
        System.out.println("Dumping Buffer Done");
    }

    public boolean isSerialPressureData(byte statusByte) {
        switch (statusByte) {
            case 0: {
                return false;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return false;
            }
            case 5: {
                return false;
            }
            case 6: {
                return false;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    boolean lcdSendGraphic(int dest, int mode, int xPos, int yPos, int xSize, int ySize, byte[] bitmapData, int size, int pixelDepth) {
        int modeNibble;
        byte[] compDataBuffer;
        if (this.params.tabletLCDCompressMode != 0) {
            int factor = mode == 2 ? this.params.tabletLCDFastCompressionFactor : this.params.tabletLCDSlowCompressionFactor;
            compDataBuffer = this.compressLCDGraphics(factor, bitmapData, size);
            this.compBufferSize = compDataBuffer.length;
        } else {
            compDataBuffer = bitmapData;
            this.compBufferSize = size;
        }
        LCDWindowedCmdType cmd = new LCDWindowedCmdType(this.compBufferSize);
        if (this.params.tabletLCDCompressMode != 0) {
            if (dest == 0) {
                cmd.setCmd((byte)8);
            } else {
                cmd.setCmd((byte)24);
            }
        } else if (dest == 0) {
            cmd.setCmd((byte)7);
        } else {
            cmd.setCmd((byte)23);
        }
        switch (pixelDepth) {
            case 0: {
                modeNibble = 0;
                break;
            }
            case 1: {
                modeNibble = 16;
                break;
            }
            case 2: {
                modeNibble = 32;
                break;
            }
            case 3: {
                modeNibble = 48;
                break;
            }
            default: {
                modeNibble = 0;
            }
        }
        cmd.setMode(mode | modeNibble);
        cmd.setXPos(xPos);
        cmd.setYPos(yPos);
        cmd.setXSize(xSize);
        cmd.setYSize(ySize);
        cmd.setData(compDataBuffer);
        return this.lcdSendCommand(cmd);
    }
}

