/*
 * Decompiled with CFR 0.152.
 */
package com.rameses.osiris3.platform;

import com.rameses.osiris3.platform.ErrorDialog;
import com.rameses.osiris3.platform.LogoffPanel;
import com.rameses.osiris3.platform.OSMainWindow;
import com.rameses.osiris3.platform.OSManager;
import com.rameses.osiris3.platform.OSPopupDialog;
import com.rameses.osiris3.platform.OSScreenLock;
import com.rameses.osiris3.platform.OSView;
import com.rameses.osiris3.platform.SubWindowImpl;
import com.rameses.platform.interfaces.ContentPane;
import com.rameses.platform.interfaces.MainWindow;
import com.rameses.platform.interfaces.Platform;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

class OSPlatform
implements Platform {
    private OSManager osManager;
    private OSMainWindow osMainWindow;

    public OSPlatform(OSManager osManager) {
        this.osManager = osManager;
        this.osMainWindow = osManager.getMainWindow();
    }

    @Override
    public void showStartupWindow(JComponent actionSource, JComponent comp, Map props) {
        String id = (String)props.get("id");
        if (id == null || id.trim().length() == 0) {
            throw new IllegalStateException("id is required for a page.");
        }
        if (this.osManager.containsView(id)) {
            return;
        }
        SubWindowImpl view = new SubWindowImpl(id, comp, this, false);
        view.setTitle((String)props.get("title"));
        this.osMainWindow.setComponent(view, "content");
    }

    @Override
    public void showWindow(JComponent actionSource, JComponent comp, Map props) {
        String id = (String)props.get("id");
        if (id == null || id.trim().length() == 0) {
            throw new IllegalStateException("id is required for a page.");
        }
        if (this.osManager.containsView(id)) {
            return;
        }
        if (this.osMainWindow.findExplorer(id) != null) {
            return;
        }
        String title = (String)props.get("title");
        if (title == null || title.length() == 0) {
            props.put("title", id);
            title = id;
        }
        comp.putClientProperty("Window.properties", props);
        String windowmode = (String)props.get("windowmode");
        if ("glasspane".equals(windowmode)) {
            this.showGlassPane(actionSource, comp, props, id);
            return;
        }
        SubWindowImpl view = new SubWindowImpl(id, comp, this);
        String canClose = (String)props.get("canclose");
        view.setCanClose(!"false".equals(canClose));
        view.setTitle(title);
        if ("explorer".equals(windowmode)) {
            this.osMainWindow.setComponent(view, windowmode);
        } else {
            this.osMainWindow.setComponent(view, "content");
        }
    }

    @Override
    public void showPopup(JComponent actionSource, JComponent comp, Map props) {
        final String id = (String)props.get("id");
        if (id == null || id.trim().length() == 0) {
            throw new IllegalStateException("id is required for a page.");
        }
        if (this.osManager.containsView(id)) {
            return;
        }
        String title = (String)props.get("title");
        if (title == null || title.length() == 0) {
            props.put("title", id);
            title = id;
        }
        comp.putClientProperty("Window.properties", props);
        String windowmode = (String)props.get("windowmode");
        if ("screenlock".equals(windowmode)) {
            this.showScreenLock(actionSource, comp, props);
            return;
        }
        if ("glasspane".equals(windowmode)) {
            this.showGlassPane(actionSource, comp, props, id);
            return;
        }
        Window parent = this.getParentWindow(actionSource);
        OSPopupDialog dialog = null;
        dialog = parent instanceof JDialog ? new OSPopupDialog((JDialog)parent) : (parent instanceof JFrame ? new OSPopupDialog((JFrame)parent) : new OSPopupDialog());
        if (!props.isEmpty()) {
            this.setProperties(dialog, props);
        }
        final OSPopupDialog dx = dialog;
        dx.setId(id);
        dx.setModal(true);
        dx.setTitle(title);
        dx.setPlatformImpl(this);
        dx.setContentPane(comp);
        String modal = props.get("modal") + "";
        if ("false".equalsIgnoreCase(modal)) {
            dx.setModal(false);
        }
        if ("false".equals(props.get("resizable") + "")) {
            dx.setResizable(false);
        }
        if ("true".equals(props.get("undecorated") + "")) {
            dx.setUndecorated(true);
        }
        if ("true".equals(props.get("alwaysOnTop") + "")) {
            dx.setAlwaysOnTop(true);
            dx.setModal(false);
        }
        dx.pack();
        Dimension dim = dx.getSize();
        int width = this.toInt(props.get("width"));
        int height = this.toInt(props.get("height"));
        int pWidth = width <= 0 ? dim.width : width;
        int pHeight = height <= 0 ? dim.height : height;
        dx.setSize(pWidth, pHeight);
        dx.setLocationRelativeTo(parent);
        dx.setSource(actionSource);
        KeyStroke ks = KeyStroke.getKeyStroke("ctrl shift I");
        ShowInfoAction al = new ShowInfoAction(comp);
        JRootPane rootPane = dx.getRootPane();
        rootPane.registerKeyboardAction(al, ks, 2);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (!OSPlatform.this.osManager.containsView(id)) {
                    dx.setVisible(true);
                }
            }
        };
        if ("true".equals(props.get("immediate") + "")) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    @Override
    public void showFloatingWindow(JComponent owner, JComponent comp, Map props) {
        this.showPopup(owner, comp, props);
    }

    public void showScreenLock(JComponent actionSource, JComponent comp, Map props) {
        String id = (String)props.get("id");
        if (id == null || id.trim().length() == 0) {
            throw new IllegalStateException("id is required for a page.");
        }
        OSScreenLock lock = this.osManager.getScreenLock();
        if (lock != null) {
            return;
        }
        lock = new OSScreenLock();
        lock.setName(id);
        lock.updateBackgroundImage();
        lock.setContent(comp);
        lock.setVisible(true);
    }

    private void showGlassPane(JComponent actionSource, JComponent comp, Map props, String id) {
        this.osMainWindow.showInGlassPane(comp, props);
    }

    @Override
    public boolean isWindowExists(String id) {
        if (this.osManager.containsView(id)) {
            return true;
        }
        if (this.osMainWindow.findExplorer(id) != null) {
            return true;
        }
        OSScreenLock c = this.osManager.getScreenLock();
        return c != null && id.equals(((Component)c).getName());
    }

    @Override
    public void activateWindow(String id) {
        OSView view = this.osManager.lookupView(id);
        if (view != null) {
            view.requestFocus();
        } else {
            Component comp = this.osMainWindow.findExplorer(id);
            if (comp != null) {
                comp.requestFocus();
            }
        }
    }

    @Override
    public void closeWindow(String id) {
        if (id == null) {
            return;
        }
        OSView view = this.osManager.lookupView(id);
        if (view == null) {
            return;
        }
        view.closeView();
    }

    @Override
    public void showError(JComponent actionSource, Exception e) {
        ErrorDialog.show(e, actionSource);
    }

    @Override
    public boolean showConfirm(JComponent actionSource, Object message) {
        Window parent = this.getParentWindow(actionSource);
        int retval = JOptionPane.showConfirmDialog(parent, message, "Confirm", 0);
        return retval == 0;
    }

    @Override
    public void showInfo(JComponent actionSource, Object message) {
        Window parent = this.getParentWindow(actionSource);
        JOptionPane.showMessageDialog(parent, message, "Information", 1);
    }

    @Override
    public void showAlert(JComponent actionSource, Object message) {
        Window parent = this.getParentWindow(actionSource);
        JOptionPane.showMessageDialog(parent, message, "Warning", 2);
    }

    @Override
    public Object showInput(JComponent actionSource, Object message) {
        Window parent = this.getParentWindow(actionSource);
        return JOptionPane.showInputDialog(parent, message);
    }

    @Override
    public MainWindow getMainWindow() {
        return this.osMainWindow;
    }

    @Override
    public void shutdown() {
        this.osMainWindow.close();
    }

    @Override
    public void logoff() {
        LogoffPanel panel = new LogoffPanel();
        this.osMainWindow.showInGlassPane(panel, null);
        this.closeAllDialogs();
        this.closeAllNonDialogViews();
        this.osManager.stopScheduledTasks();
        OSScreenLock lock = this.osManager.getScreenLock();
        if (lock != null) {
            lock.setVisible(false);
        }
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
        this.osMainWindow.hideGlassPane();
        OSScreenLock lock = this.osManager.getScreenLock();
        if (lock != null) {
            lock.setVisible(false);
        }
    }

    private Window getParentWindow(JComponent source) {
        if (source == null) {
            Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (w != null && w.isShowing()) {
                return w;
            }
            return this.osMainWindow.getComponent();
        }
        return SwingUtilities.getWindowAncestor(source);
    }

    private void setProperties(OSPopupDialog bean, Map props) {
        if ("false".equalsIgnoreCase(props.get("resizable") + "")) {
            bean.setResizable(false);
        }
        if ("true".equalsIgnoreCase(props.get("alwaysOnTop") + "")) {
            bean.setAlwaysOnTop(true);
        }
        if ("false".equalsIgnoreCase(props.get("enabled") + "")) {
            bean.setEnabled(false);
        }
        if ("true".equalsIgnoreCase(props.get("undecorated") + "")) {
            bean.setUndecorated(true);
        }
    }

    private int toInt(Object value) {
        if (value == null) {
            return -1;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception ex) {
            return -1;
        }
    }

    private void closeAllDialogs() {
        List<OSView> list = this.osManager.findViews("popup");
        while (!list.isEmpty()) {
            try {
                list.remove(0).closeView();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private void closeAllNonDialogViews() {
        List<OSView> list = this.osManager.findViews("screenlock");
        while (!list.isEmpty()) {
            try {
                list.remove(0).closeView();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        this.osManager.unregisterAllViews();
    }

    private class ShowInfoAction
    implements ActionListener {
        private Component source;

        ShowInfoAction(Component source) {
            this.source = source;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!(this.source instanceof ContentPane.View)) {
                return;
            }
            ((ContentPane.View)((Object)this.source)).showInfo();
        }
    }
}

