/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport;

import it.businesslogic.ireport.IReportConnectionEditor;
import it.businesslogic.ireport.connection.gui.BasicIReportConnectionEditor;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.I18n;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;

public abstract class IReportConnection {
    private String name = "";

    public boolean isJDBCConnection() {
        return false;
    }

    public boolean isJRDataSource() {
        return true;
    }

    public abstract String getDescription();

    public Connection getConnection() {
        return null;
    }

    public JRDataSource getJRDataSource() {
        return new JREmptyDataSource();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HashMap getProperties() {
        return new HashMap();
    }

    public void loadProperties(HashMap map) {
    }

    public void save(PrintWriter pw) {
        HashMap hm = this.getProperties();
        pw.println("\t<iReportConnection name=\"" + this.getName() + "\" connectionClass=\"" + this.getClass().getName() + "\">");
        for (String key : hm.keySet()) {
            pw.println("\t\t<connectionParameter name=\"" + key + "\"><![CDATA[" + hm.get(key) + "]]></connectionParameter>");
        }
        pw.println("\t</iReportConnection>");
    }

    public String toString() {
        return this.getName();
    }

    public Map getSpecialParameters(Map map) throws JRException {
        return map;
    }

    public Map disposeSpecialParameters(Map map) {
        return map;
    }

    public void test() throws Exception {
        JOptionPane.showMessageDialog(MainFrame.getMainInstance(), I18n.getString("messages.connectionDialog.connectionTestSuccessful", "Connection test successful!"), "", 1);
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new BasicIReportConnectionEditor();
    }
}

