/*
 * Decompiled with CFR 0.152.
 */
package it.businesslogic.ireport.gui;

import it.businesslogic.ireport.gui.ConnectionsDialog;
import it.businesslogic.ireport.gui.MainFrame;
import it.businesslogic.ireport.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class ToolbarConnectionPanel
extends JPanel {
    private boolean updating = false;
    private MainFrame mf = null;
    private StringBuffer outputBuffer;
    private JButton jButtonDatasources;
    private JComboBox jComboBoxConnections;
    private JToolBar jToolBarConnections;

    public ToolbarConnectionPanel(MainFrame mf) {
        this.mf = mf;
        this.initComponents();
    }

    public JToolBar getToolBar() {
        return this.jToolBarConnections;
    }

    private void initComponents() {
        this.jToolBarConnections = new JToolBar();
        this.jComboBoxConnections = new JComboBox();
        this.jButtonDatasources = new JButton();
        this.setLayout(new BorderLayout());
        this.setName("ToolbarConnectionPanel");
        this.getAccessibleContext().setAccessibleName("ToolbarConnectionPanel");
        this.jComboBoxConnections.setMaximumSize(new Dimension(250, Short.MAX_VALUE));
        this.jComboBoxConnections.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ToolbarConnectionPanel.this.jComboBoxConnectionsActionPerformed(evt);
            }
        });
        this.jToolBarConnections.add(this.jComboBoxConnections);
        this.jComboBoxConnections.getAccessibleContext().setAccessibleName("ToolbarConnections");
        this.jButtonDatasources.setIcon(new ImageIcon(this.getClass().getResource("/it/businesslogic/ireport/icons/toolbars/datasources.png")));
        this.jButtonDatasources.setToolTipText("Datasources");
        this.jButtonDatasources.setBorder(null);
        this.jButtonDatasources.setBorderPainted(false);
        this.jButtonDatasources.setFocusPainted(false);
        this.jButtonDatasources.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonDatasources.setMaximumSize(new Dimension(24, 23));
        this.jButtonDatasources.setMinimumSize(new Dimension(22, 22));
        this.jButtonDatasources.setPreferredSize(new Dimension(22, 22));
        this.jButtonDatasources.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ToolbarConnectionPanel.this.jButtonDatasourcesActionPerformed(evt);
            }
        });
        this.jToolBarConnections.add(this.jButtonDatasources);
        this.add((Component)this.jToolBarConnections, "North");
        this.jToolBarConnections.getAccessibleContext().setAccessibleName("ToolbarConnections");
    }

    private void jButtonDatasourcesActionPerformed(ActionEvent evt) {
        try {
            ConnectionsDialog cd = new ConnectionsDialog((Frame)this.getMainFrame(), true);
            cd.setVisible(true);
            this.updateConnections();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jComboBoxConnectionsActionPerformed(ActionEvent evt) {
        if (!this.updating && this.jComboBoxConnections.getSelectedItem() != null) {
            this.getMainFrame().getProperties().put("DefaultConnection", this.jComboBoxConnections.getSelectedItem());
            this.getMainFrame().saveiReportConfiguration();
        }
    }

    public JComboBox getJComboBoxConnextions() {
        return this.jComboBoxConnections;
    }

    public synchronized void updateConnections() {
        this.updating = true;
        try {
            Misc.updateComboBox(this.jComboBoxConnections, this.getMainFrame().getConnections());
            if (this.getMainFrame().getProperties().get("DefaultConnection") != null) {
                this.jComboBoxConnections.setSelectedItem(this.getMainFrame().getProperties().get("DefaultConnection"));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.updating = false;
    }

    private MainFrame getMainFrame() {
        return this.mf;
    }
}

